import Protocol from "./Protocol";
function compareStrings(a, b) {
    if (a.length !== b.length)
        return false;
    return a.every((curr) => b.indexOf(curr) >= 0);
}
function compareMaps(a, b) {
    var _a, _b;
    const keys = Array.from((_a = a.keys) !== null && _a !== void 0 ? _a : []);
    if (!compareStrings(keys, Array.from((_b = b.keys) !== null && _b !== void 0 ? _b : [])))
        return false;
    return keys.every((key) => a[key] === b[key]);
}
/**
 * Network interface representing a NEO blockchain network.
 * This inherits from the network.protocol file used in the C# implementation and adds in additional configurations.
 * @param config - NetworkLike JS object
 */
export class Network {
    constructor(config = {}, name = null) {
        this.name = config.Name || config.name || name || "RandomNet";
        const protocolLike = Object.assign({}, config.protocol || config.ProtocolConfiguration || {});
        this.protocol = new Protocol(protocolLike);
        this.nodes = config.Nodes || config.nodes || [];
        this.extra = Object.assign({}, config.ExtraConfiguration || config.extra || {});
    }
    /**
     * Exports the class as a JSON format.
     */
    export() {
        return {
            name: this.name,
            protocol: this.protocol.export(),
            extra: this.extra,
            nodes: this.nodes,
        };
    }
    /**
     * Exports using PascalCase convention for keys.
     */
    toConfiguration() {
        return {
            Name: this.name,
            ProtocolConfiguration: this.protocol.toConfiguration(),
            ExtraConfiguration: this.extra,
            Nodes: this.nodes,
        };
    }
    equals(other) {
        var _a, _b, _c;
        return (this.name === other.name &&
            this.protocol.equals((_a = other.protocol) !== null && _a !== void 0 ? _a : {}) &&
            compareStrings(this.nodes, (_b = other.nodes) !== null && _b !== void 0 ? _b : []) &&
            compareMaps(this.extra, (_c = other.extra) !== null && _c !== void 0 ? _c : {}));
    }
}
export default Network;
//# sourceMappingURL=Network.js.map