import Protocol, { ProtocolJSON, ProtocolLike } from "./Protocol";
import { NeonObject } from "../model";
export interface NetworkLike {
    name: string;
    protocol: Partial<ProtocolLike>;
    nodes: string[];
    extra: {
        [key: string]: string;
    };
}
/**
 * This is a expanded interface of protocol.json file found in the C# implementation.
 */
export interface NetworkJSON {
    Name: string;
    ProtocolConfiguration: ProtocolJSON;
    Nodes: string[];
    ExtraConfiguration: {
        [key: string]: string;
    };
}
/**
 * Network interface representing a NEO blockchain network.
 * This inherits from the network.protocol file used in the C# implementation and adds in additional configurations.
 * @param config - NetworkLike JS object
 */
export declare class Network implements NeonObject<NetworkLike> {
    name: string;
    protocol: Protocol;
    nodes: string[];
    extra: {
        [key: string]: string;
    };
    constructor(config?: Partial<NetworkLike & NetworkJSON>, name?: null);
    /**
     * Exports the class as a JSON format.
     */
    export(): NetworkLike;
    /**
     * Exports using PascalCase convention for keys.
     */
    toConfiguration(): NetworkJSON;
    equals(other: Partial<NetworkLike>): boolean;
}
export default Network;
//# sourceMappingURL=Network.d.ts.map