import loglevel from "loglevel";
import prefix from "loglevel-plugin-prefix";
prefix.reg(loglevel);
loglevel.setDefaultLevel("silent");
export function setAll(lvl) {
    Object.keys(loglevel.getLoggers()).map((key) => {
        const lg = loglevel.getLogger(key);
        lg.setLevel(lvl);
    });
}
const fn = (level, name, timestamp) => {
    const ts = timestamp !== null && timestamp !== void 0 ? timestamp : new Date().toUTCString();
    level = level.toUpperCase();
    return `[${ts}] (${name}) ${level}: `;
};
export default (label) => {
    const l = loglevel.getLogger(label);
    prefix.apply(l, { format: fn });
    return l;
};
export const logger = loglevel;
//# sourceMappingURL=logging.js.map