/**
 * Parses a string, number or enum to an enum.
 */
export function parseEnum(input, enumType) {
    if (typeof input === "string") {
        if (input in enumType) {
            return enumType[input];
        }
        throw new Error(`${input} not found in ${enumType}!`);
    }
    return input;
}
//# sourceMappingURL=internal.js.map