import { tx, sc, u, wallet } from "@cityofzion/neon-core";
export declare class TransactionBuilder {
    private vmScripts;
    private networkFee;
    private systemFee;
    private validUntilBlock;
    private attributes;
    private signers;
    private witnesses;
    static newBuilder(): TransactionBuilder;
    /**
     * Adds the logic for claiming gas. Alternatively, you may just trigger the gas claim by performing an actual transaction involving NEO.
     * @param account - Account to claim gas on.
     */
    addGasClaim(account: wallet.Account): TransactionBuilder;
    /**
     *  Adds the logic to send tokens around.
     * @param account - originating account
     * @param destination - account where the tokens will be sent
     * @param tokenScriptHash - scripthash of the token contract
     * @param amt - Amount of tokens in integer format.
     */
    addNep17Transfer(account: wallet.Account, destination: string, tokenScriptHash: string, amt: number | string | u.BigInteger): TransactionBuilder;
    /**
     * Adds the logic to vote for a candidate.
     * @param account - Account containing the NEO.
     * @param candidatePublicKey - The candidate's publickey in hex big endian.
     */
    addVote(account: wallet.Account, candidatePublicKey: string): TransactionBuilder;
    /**
     * Adds a signature field representing the request for a signature from this account.
     * Under the hood, this adds a Signer and empty Witness to the transaction. The Signer defaults to the basic scope.
     * For more advanced usage, plase manually add your own Signers and Witnesses.
     * @param account - account that has to sign the transaction.
     */
    addBasicSignatureField(account: wallet.Account): this;
    /**
     * Sets an account to pay fees for this transaction.
     * The first Signer defaults to the payer.
     * @param account - Account to pay fees from.
     */
    setFeeAccount(account: wallet.Account): this;
    /**
     * Add signers. Will deduplicate signers and merge scopes.
     * This does not add any Witnesses.
     */
    addSigners(...signers: tx.SignerLike[]): this;
    /**
     * You can add multiple intents to the transaction
     */
    addContractCall(...contractCalls: sc.ContractCall[]): this;
    addScript(hexString: string): this;
    /**
     * Add an attribute.
     * @param usage - The usage type. Do refer to txAttrUsage enum values for all available options.
     * @param data - The data as hexstring.
     */
    addAttributes(...attrs: tx.TransactionAttributeLike[]): this;
    /**
     * Adds an unsigned witness to the transaction.
     * Will deduplicate witnesses based on verificationScript.
     * Required to calculate the network fee correctly.
     */
    addEmptyWitness(account: wallet.Account): this;
    addEmptyWitnesses(...accounts: wallet.Account[]): this;
    setSystemFee(fee: u.BigInteger): this;
    setNetworkFee(fee: u.BigInteger): this;
    build(): tx.Transaction;
}
//# sourceMappingURL=TransactionBuilder.d.ts.map