import { logging } from "@cityofzion/neon-core";
const log = logging.default("api");
export class Subscription {
    constructor(contract, unsubscribeFunction) {
        this.contract = contract;
        this.unsubscribeFunction = unsubscribeFunction;
        log.info(`Created Subscription: ${this.contract}`);
    }
    get name() {
        return `Subscription[${this.contract}]`;
    }
    /**
     * Unsubscribe a specific function from a contract
     */
    unsubscribe() {
        this.unsubscribeFunction();
    }
}
export default Subscription;
//# sourceMappingURL=subscription.js.map