import { sc, u } from "@cityofzion/neon-core";
export async function getCandidates(client) {
    const script = new sc.ScriptBuilder()
        .emitContractCall(sc.NeoContract.INSTANCE.getCandidates())
        .build();
    const res = await client.invokeScript(u.HexString.fromHex(script));
    const arrayOfCandidates = res.stack;
    return arrayOfCandidates[0].value.map((i) => {
        return {
            publicKey: u.HexString.fromBase64(i.value[0].value).toBigEndian(),
            votes: parseInt(i.value[1].value),
        };
    });
}
//# sourceMappingURL=getCandidates.js.map