import { tx, u } from "@cityofzion/neon-core";
/**
 * Calculates the network fee required to process the transaction.
 * The fields signers, attributes and script needs to be fully populated for this to work.
 *
 * @param txn - A partially filled out transaction.
 * @param feePerByte - The current feePerByte in Policy contract.
 * @param signingAccts - The accounts that will be signing this.
 */
export declare function calculateNetworkFee(txn: tx.Transaction, feePerByte: number | u.BigInteger, executionFeeFactor: number | u.BigInteger): u.BigInteger;
//# sourceMappingURL=calculateNetworkFee.d.ts.map