import { tx, rpc, u } from "@cityofzion/neon-core";
export declare enum ValidationAttributes {
    None = 0,
    ValidUntilBlock = 1,
    SystemFee = 2,
    NetworkFee = 4,
    Script = 8,
    All = 15
}
export declare type ValidationSuggestion<T> = {
    valid: boolean;
    /**
     * Whether this is auto-fixed by validator.
     */
    fixed: boolean;
    prev?: T;
    suggestion?: T;
    message?: string;
};
export interface ValidationResult {
    /**
     * Whether the transaction is valid after validation
     */
    valid: boolean;
    result: {
        validUntilBlock?: ValidationSuggestion<number>;
        script?: ValidationSuggestion<void>;
        systemFee?: ValidationSuggestion<u.BigInteger>;
        networkFee?: ValidationSuggestion<u.BigInteger>;
    };
}
/**
 * A class with functions to validate transaction
 */
export declare class TransactionValidator {
    static TX_LIFESPAN_SUGGESTION: number;
    /**
     * Transaction will be validated on this rpc node
     */
    rpcClient: rpc.NeoServerRpcClient;
    /**
     * Transaction that will be validated
     */
    transaction: tx.Transaction;
    constructor(rpc: rpc.NeoServerRpcClient, transaction: tx.Transaction);
    /**
     * validate validUntilBlock.
     * @param autoFix - autofix when number is below current height.
     */
    validateValidUntilBlock(autoFix?: boolean): Promise<ValidationSuggestion<number>>;
    /**
     * Validate intents
     */
    validateScript(): Promise<ValidationSuggestion<void>>;
    /**
     * validate systemFee
     * @param autoFix - autofix when fee is too low.
     */
    validateSystemFee(autoFix?: boolean): Promise<ValidationSuggestion<u.BigInteger>>;
    /**
     * Validate NetworkFee
     * @param autoFix - autofix when fee is too low.
     */
    validateNetworkFee(autoFix?: boolean): Promise<ValidationSuggestion<u.BigInteger>>;
    validate(attrs: ValidationAttributes, autoFix?: ValidationAttributes): Promise<ValidationResult>;
}
//# sourceMappingURL=validator.d.ts.map