import { tx, wallet } from "@cityofzion/neon-core";
/**
 * A class with functions to sign transaction
 */
export declare class TransactionSigner {
    /**
     * transaction to be signed
     */
    transaction: tx.Transaction;
    constructor(transaction: tx.Transaction);
    /**
     * Sign a transaction with Accounts or Private Keys.
     * This is used when you have full access to signer accounts
     * @param accounts - accounts that will sign this transaction
     */
    signWithAccount(...accounts: (wallet.Account | string)[]): void;
    /**
     * Sign a transaction with Witnesses.
     * This can be used when you accept a signature from someone else
     * @param witnesses - witnesses that will be added to the transaction
     */
    signWithWitness(...witnesses: tx.Witness[]): void;
    /**
     * Sign a transaction with multi-signatures for multi-sig account
     * @param multisigAccount - multisig account
     * @param witnesses - signatures from accounts within the multisig-account
     */
    signWithMultiSigAccount(multisigAccount: wallet.Account, ...witnesses: tx.Witness[]): void;
    private _checkAcc;
    private _checkWitness;
    private _checkMultisigAcc;
    private _getSignerHashes;
    private _assertShouldSign;
}
//# sourceMappingURL=signer.d.ts.map