"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Subscription = void 0;
const neon_core_1 = require("@cityofzion/neon-core");
const log = neon_core_1.logging.default("api");
class Subscription {
    constructor(contract, unsubscribeFunction) {
        this.contract = contract;
        this.unsubscribeFunction = unsubscribeFunction;
        log.info(`Created Subscription: ${this.contract}`);
    }
    get name() {
        return `Subscription[${this.contract}]`;
    }
    /**
     * Unsubscribe a specific function from a contract
     */
    unsubscribe() {
        this.unsubscribeFunction();
    }
}
exports.Subscription = Subscription;
exports.default = Subscription;
//# sourceMappingURL=subscription.js.map