import { CallbackFunction } from "./responses";
import Subscription from "./subscription";
export declare class Notifications {
    private url;
    private uniqueIdentifier;
    get name(): string;
    private subscriptions;
    /**
     * Create a new notification service that handles contract subscriptions
     * Source code and instructions on how to run this service are available on https://github.com/corollari/neo-PubSub
     * @param url - URL of a notifications service.
     */
    constructor(url: string);
    /**
     * Subscribe to event notifications of a specific contract
     * @param contract - Hash of the contract (null for all contracts) to subscribe to
     * @param callback - Function to call when a notification is received.
     * @returns Subscription object that can be used to cancel the subscription
     */
    subscribe(contract: string | null, callback: CallbackFunction): Subscription;
    /**
     * Unsubscribe all subscriptions associated with a specific contract
     * @param contract - Hash of the contract (or null for subscriptions to all contracts) to unsubscribe callbacks from
     */
    unsubscribeContract(contract: string | null): Promise<void>;
    /**
     * Unsubscribe all subscriptions (equivalent to calling unsubscribeContract() once for every contract)
     */
    unsubscribeAll(): Promise<void>;
    private createWebsocketForContract;
    private normalizeContract;
}
export default Notifications;
//# sourceMappingURL=class.d.ts.map