import { rpc, sc, tx, u, wallet } from "@cityofzion/neon-core";
import { Candidate } from "./api/getCandidates";
import { ValidationResult } from "./transaction";
import { SigningFunction } from "./transaction/signing";
export interface NetworkFacadeConfig {
    node: string | rpc.NeoServerRpcClient;
}
export interface Nep17TransferIntent {
    from: wallet.Account;
    to: string;
    integerAmt?: number | string | u.BigInteger;
    decimalAmt?: number | string;
    contractHash: string;
}
export interface signingConfig {
    signingCallback: SigningFunction;
}
export declare class NetworkFacade {
    magicNumber: number;
    client: rpc.NeoServerRpcClient;
    static fromConfig(config: NetworkFacadeConfig): Promise<NetworkFacade>;
    private constructor();
    initialize(): Promise<void>;
    getRpcNode(): rpc.NeoServerRpcClient;
    /**
     * Constructs and executes a transaction of multiple token transfers
     * @param intents - Token transfers
     * @param config - Configuration
     */
    transferToken(intents: Nep17TransferIntent[], config: signingConfig): Promise<string>;
    /**
     * Claims all the gas available for the specified account. Do note that GAS is automatically claimed when you perform a transaction involving NEO.
     * @param acct - The account to claim gas on
     * @param config - Configuration
     */
    claimGas(acct: wallet.Account, config: signingConfig): Promise<string>;
    /**
     * Convenience method for getting list of candidates.
     */
    getCandidates(): Promise<Candidate[]>;
    vote(acct: wallet.Account, candidatePublicKey: string, config: signingConfig): Promise<string>;
    /**
     * Performs validation of all attributes on the given transaction.
     * @param txn - Transaction to validate
     */
    validate(txn: tx.Transaction): Promise<ValidationResult>;
    /**
     *  Signs a transaction according to the signing configuration. The input transaction is modified with the signatures and returned.
     * @param txn - Transaction to sign
     * @param config - Configuration
     * @returns
     */
    sign(txn: tx.Transaction, config: signingConfig): Promise<tx.Transaction>;
    invoke(contractCall: sc.ContractCall): Promise<rpc.InvokeResult>;
}
//# sourceMappingURL=NetworkFacade.d.ts.map