# N3 TranslateMe contracts and SDK

This repo includes the Neo N3 smart contracts and their SDKs for the TranslateMe project.

Depending on your environment, please refer one of the options below

## For a local privatenet

### Dependencies
1. Neo-Express
2. Node v14.16+

### Quickstart

1. In project root: `npm install`
2. Ensure you are running a node using the project neo-express config `neoxp run -s 1`
3. Transfer yourself some GAS: `neoxp transfer 100000 GAS genesis coz`
3. Deploy the contract: `npm run deploy`
4. Initialize the contract: `npm run initialize`
5. SDK configuration variables:
  ```typescript
  const NODE = 'http://localhost:50012'
  const SCRIPT_HASH = '0xe949e732fb9d43c551b7f584bec5e500f82fb161'
  const TIME_CONSTANT = 2000
  ```
6. Refer to the [Contract Interfacing](#contract-interfacing) section to information about using the SDK

## For a remote blockchain deployment like testnet or mainnet

### Dependencies
1. Node v14.16+

### Quickstart
1. SDK configuration variables (refer to [dora](https://dora.coz.io/monitor) for other networks):
  ```typescript
  const NODE = 'https://testnet1.neo.coz.io:443' //testnet
  const SCRIPT_HASH = '0x10c3d1730b957139e81941d036ef5c6699c320b5'
  const TIME_CONSTANT = 20000
  ```
2. Refer to the [Contract Interfacing](#contract-interfacing) section to information about using the SDK


## Contract interfacing
This project includes a typescript sdk which is already configured to interface with the smart contract.  To use it,
pull this project and import the `dist` directory:

```typescript
const sdk = require("../dist")
tmn = await new sdk.TMN({
    node: NODE
    scriptHash: SCRIPT_HASH
  })
```

### Some basic examples

#### Getting basic contract information
```typescript
  const symbol = await tmn.symbol() // => "TMN"
  const decimals = await tmn.decimals() // => 8
  const totalSupply = await tmn.totalSupply() // => {{the total supply}}
```

#### Minting to a single address
```typescript
  const Neon = require("@cityofzion/neon-core") //You will need to install this (^5.0.0-next.16)

  const pKey = `{{Your admin private key}}`
  const adminWallet = new Neon.wallet.Account(pKey)
  const mintPayload = {
    "address": {{some address}},  // example: "NSEQNxueCAf6Qp3QEARj5ztpkhBi1cxayY"
    "amount": 1000 //number of tokens to mint
  }
  const txid = await tmn.mint(mintPayload, adminWallet)

  await sdk.helpers.sleep(TIME_CONSTANT) // wait for the transaction to persist on-chain before doing anything associated with the minting

  const balance = await sdk.balanceOf(mintPayload.address) // get the balance of the address
```

#### Batch minting
```typescript
  const Neon = require("@cityofzion/neon-core") //You will need to install this (^5.0.0-next.16)

  const mintAmount = 1000  //the number of tokens to mint to each address
  const pKey = `{{Your admin private key}}`

  const adminWallet = new Neon.wallet.Account(pKey)

  //create a bunch of arbitrary addresses to mint tokens to
  const mintPayload = []
  for (let i = 0; i < userCount; i++) {
    let user = new Neon.wallet.Account()
    mintPayload.push({
      "address": user.address,
      "amount": mintAmount
    })
  }

  let txid = await tmn.mintBatch(mintPayload, adminWallet)
```

Refer to `./sdk_ts/test` for other various recipes.


## Deploying to other networks
To depoy to other networks, *MAKE SURE* to use a privatekey as a runtime variable to the deploy script or
update default.neo-express. We dont want to use the private key that is saved in the repo.




